<?php

$data = $_SERVER['REQUEST_METHOD'] === "POST" ? $_POST : $_GET;

if (!isset($data['ip'])) {
    exit("ip es requerida.");
}

if (!isset($data['key'])) {
    exit("la key de autorizacion es requerida.");
}

$allowedIpsFile = 'allowed_ips.txt';

function getAllowedIpsFromFile($filePath) {
    if (!file_exists($filePath)) {
        return array();
    }
    
    $fileContent = file_get_contents($filePath);
    $ips = explode("\n", $fileContent);
    return array_filter(array_map('trim', $ips));
}

function addIpToFile($filePath, $newIp) {
    $allowedIps = getAllowedIpsFromFile($filePath);

    if (count($allowedIps) >= 5) {
        echo "No se puede registrar más IPs. El límite es 5.";
        return false;
    }

    if (in_array($newIp, $allowedIps)) {
        echo "La IP ya está registrada.";
        return false;
    }

    file_put_contents($filePath, $newIp . PHP_EOL, FILE_APPEND);
    echo "IP registrada exitosamente.";
    return true;
}

function deleteIpFromFile($filePath, $ipToDelete) {
    $allowedIps = getAllowedIpsFromFile($filePath);

    if (!in_array($ipToDelete, $allowedIps)) {
        echo "La IP no está registrada.";
        return false;
    }

    $newAllowedIps = array_filter($allowedIps, function($ip) use ($ipToDelete) {
        return $ip !== $ipToDelete;
    });

    file_put_contents($filePath, implode(PHP_EOL, $newAllowedIps) . PHP_EOL);
    echo "IP eliminada exitosamente.";
    return true;
}

$newIp = $data['ip'];
$key = $data['key'];
$delete = $data['delete'] ?? false;

if($key != "57331-1D6B9-44BRM"){
    exit("no tienes acceso para poder enviar peticiones.");
}

if ($delete == false) {
    if (!filter_var($newIp, FILTER_VALIDATE_IP)) {
        echo "La IP proporcionada no es válida.";
        exit;
    }

    addIpToFile($allowedIpsFile, $newIp);
    exit;
} else {
    deleteIpFromFile($allowedIpsFile, $newIp);
    exit;
}

?>
