<?php
class Api{
	private $username="";
	private $password="";
	
	private $cook = array();
	private $default_ua = "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/119.0";
	private $headers = array(
		'ua'=>'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/119.0',
		'origin'=>'Origin: https://id5.cloud.huawei.com',
		'content'=>'Content-Type: application/x-www-form-urlencoded',
	);
	
	private $devices_list= array(
		'device_list'=>array()
	);
	
	private function login($username,$password){
		return false;
	}
	
	private function execute_js($user , $pass){
		$descriptorspec = array(
			0 => array("pipe", "r"), // stdin
			1 => array("pipe", "w"), // stdout
			2 => array("pipe", "w"), // stderr
		);

		// Replace this with the actual path to node executable
		$arguments = [$user , $pass];
		$command = "node nodes/google.js " . escapeshellarg($arguments[0]) . " " . escapeshellarg($arguments[1]);
		$process = proc_open($command, $descriptorspec, $pipes);

		if (is_resource($process)) {
			fclose($pipes[0]); // close stdin

			$output = stream_get_contents($pipes[1]); // read stdout
			fclose($pipes[1]);

			$errorOutput = stream_get_contents($pipes[2]); // read stderr
			fclose($pipes[2]);

			$returnValue = proc_close($process); // close process

			if (!empty($errorOutput)) {
				return false;
			}else{
				return $output;
			}
		}
	}
	
	public function start_remove($username, $password,$autoremove){
		
		$this->username = $username;
		$this->password = $password;
		
		$response = $this->execute_js($username,$password);
		$response = str_replace("\n","",$response);
		$response = json_decode($response,true);
		
		if($response['success'] == true){
			
			if($autoremove){
				$this->remove_all_device();
			}
			
			$this->devices_list['success'] = true;
			$this->devices_list['id'] = $this->username;
			$this->devices_list['pwd'] = $this->password;
			$this->devices_list['device_list'] = array_values($this->devices_list['device_list']);
			$this->devices_list['autoremove'] = $autoremove;
			
			return $this->devices_list;
			
		}else{
			echo '{"success":false,"msg": "Invalid username or password."}';
			exit();
		}
	}
	
	private function remove_all_device(){
		return true;
	}
	
	private function saveCookie($response){
		$result_with_headers = $response[0];
		preg_match_all('/^Set-Cookie:\s*([^;]*)/mi', $result_with_headers, $matches);
		$cookies = "";
		foreach($matches[0] as $value){
			$value = str_replace("Set-Cookie: ","",$value);
			$cookies .= $value."; ";

			$h = explode("=", $value);
			$v = str_replace($h[0]."=","",$value);
			$this->cook[$h[0]]=$v;	
		}
		return $cookies;
	}
	
	private function getHeaders($response) { 
		$headers = array(); 
		$header_text = substr($response, 0, strpos($response, "\r\n\r\n")); 
		foreach (explode("\r\n", $header_text) as $i => $line) 
			 if ($i === 0) ; 
			 else { 
				  list ($key, $value) = explode(': ', $line); $header_key = Inflector::underscore($key); $headers[$header_key] = "$key: $value"; 
			 } 
		return $headers; 
	}
	
	private function get_web_response($url,$data='',$header=array(),$method='GET',$ua='iBypasser Agent',$authorization=null){
		$ch = curl_init($url);
		curl_setopt($ch ,CURLOPT_HTTP_VERSION,CURL_HTTP_VERSION_1_1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_USERAGENT, $ua);   
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
		
		if(strtoupper($method=='POST') || strtoupper($method=='PUT')){
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		}
		
		// curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		if($authorization!==null){
			curl_setopt($ch, CURLOPT_USERPWD, $authorization);
		}
		  
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_VERBOSE, true);

		
		curl_setopt($ch, CURLOPT_HEADER, true);
		$result_with_headers = curl_exec($ch);
		$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$body = substr($result_with_headers, $header_size);
		$redirectURL = curl_getinfo($ch,CURLINFO_EFFECTIVE_URL );
		curl_close($ch);
		
		return array($result_with_headers,$httpcode,$body,$redirectURL);
	}

}
?>