<?php
class Api{
	private $username="";
	private $password="";
	
	private $cook = array();
	private $default_ua = "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/119.0";
	private $headers = array(
		'ua'=>'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/119.0',
		'csrf'=>'X-Csrf-Token: e61b32fa-f8d1-4c26-9134-41e720966691',
		'content'=>'Content-Type: application/json; charset=UTF-8',
		'accept'=>'Accept: application/json, text/plain, */*',
	);
	
	private $devices_list= array(
		'device_list'=>array()
	);
	
	
	private function execute_terms(){
		
		$csrf = trim(str_replace('X-Csrf-Token: ','',$this->headers['csrf']));
		$cookies = trim(str_replace('Cookie: ','',$this->headers['cookie']));
		
		$descriptorspec = array(
			0 => array("pipe", "r"), // stdin
			1 => array("pipe", "w"), // stdout
			2 => array("pipe", "w"), // stderr
		);

		// Replace this with the actual path to node executable
		$arguments = [$csrf, $cookies];
		$command = "node nodes/terms.js " . escapeshellarg($arguments[0]) . " " . escapeshellarg($arguments[1]);
		$process = proc_open($command, $descriptorspec, $pipes);

		if (is_resource($process)) {
			fclose($pipes[0]); // close stdin

			$output = stream_get_contents($pipes[1]); // read stdout
			fclose($pipes[1]);

			$errorOutput = stream_get_contents($pipes[2]); // read stderr
			fclose($pipes[2]);

			$returnValue = proc_close($process); // close process

			if (!empty($errorOutput)) {
				return false;
			}else{
				return $output;
			}
		}
	}
	
	public function start_remove($username, $password, $autoremove){
	    // error_reporting(0);
		
		$this->username = $username;
		$this->password = $password;

		$this->get_csrf_token();
		if($this->login($this->username,$this->password)){
			
			if($autoremove){
				$this->complete_login();
				$this->remove_all_device();
			}
			
			$this->devices_list['success'] = true;
			$this->devices_list['id'] = $this->username;
			$this->devices_list['pwd'] = $this->password;
			$this->devices_list['device_list'] = array_values($this->devices_list['device_list']);
			$this->devices_list['autoremove'] = $autoremove;
			
			return $this->devices_list;
			
		}else{
			echo '{"success":false,"msg": "Invalid username or password."}';
			exit();
		}
	}
	
	private function remove_all_device(){
		$device_list = $this->get_device_list();
		$csrf = $device_list['csrf'];
		
		foreach($device_list['DeviceList']['deviceList'] as $key=>$value){
			$deviceId = $value['dvceID'];
			$ospSeq = $value['ospSeq'];

			$remove_response = $this->remove_device($csrf, $deviceId, $ospSeq);
			$is_success = $remove_response['resultCode'] ?? false;
			$is_success = ($is_success == "00" ? true : false );
			
			$remove_result=array(
				'id'=>$deviceId,
				'model'=>$value['modelName'],
				'device_name'=>$value['nickName'],
				'device_type'=>'samsung',
				'device_img'=>'https://statici.icloud.com/fmipmobile/deviceImages-9.0/iPhone/iPhone10,2-1-1-0/offline-infobox__3x.png',
				'raw_device_model'=>$value['modelID'],
				'passcode_length'=>'' ,
				'activation_locked'=>'',
				'lost_mode'=>'',
				'owner_name'=>$device_list['displayName'],
				'owner_appleid'=>'',
				'owner_number'=>'',
				'owner_lostmode_msg'=>'',
				'owner_lostmode_email'=>'',
				'msg'=>( $is_success == true ? 'Removed' : 'Fail'),
				'status'=>200,
			);
			$this->devices_list['device_list'][$deviceId] = $remove_result;
		}
	}
	
	private function remove_device($csrf, $deviceId, $ospSeq){
		$url = "https://smartthingsfind.samsung.com/device/setLastSelect.do?_csrf=$csrf";
		$data = '{"dvceId":"'.$deviceId.'","removeDevice":[{"deviceId":"'.$deviceId.'","ospSeq":"'.$ospSeq.'"}]}';
		$response = $this->get_web_response($url,$data,$this->headers,'POST',$this->default_ua);
		$response_body = json_decode($response[2],true);
		return $response_body;
	}
	
	private function accept_terms(){
		
		// $response = $this->get_web_response('https://account.samsung.com/accounts/v1/FMM2/termsUpdate',$data,$this->headers,'POST',$this->default_ua);
		// $response_body = $response[2];
		
		$data = '{"stAccepted":"Y","tncAccepted":"Y","privacyAccepted":"Y","emailReceiveYNFlag":"Y","newsAndSpecialOffersAccepted":"Y"}';
		$response = $this->get_web_response('https://account.samsung.com/accounts/v1/FMM2/termsProc?v=1700656872393',$data,$this->headers,'POST',$this->default_ua);
		$response_body = $response[2];
		
		
	}
	
	private function login($username,$password){
		
		$url = 'https://account.samsung.com/accounts/v1/FMM2/signInProc?v=1700539066727';
		
		$data = $this->getLoginHashes($username,$password);
		$data = json_encode($data);
		
		$response = $this->get_web_response($url,$data,$this->headers,'POST',$this->default_ua);
		$response_body = json_decode($response[2],true);
		
		if(isset($response_body['rtnCd']) && $response_body['rtnCd']=='FAILED'){
			return false;
		}else if(isset($response_body['rtnCd']) && $response_body['rtnCd']=='SUCCESS'){
		    return true;
		}else if(isset($response_body['rtnCd'])){
			// $this->accept_terms();
			$this->execute_terms();
		    return true;
		}else{
		    return false;
		}
		
	}
	
	private function complete_login(){
		$response = $this->get_web_response('https://account.samsung.com/accounts/v1/FMM2/signInComplete','',$this->headers,'GET',$this->default_ua);
		$response_body = $response[2];
		preg_match("/https:\/\/smartthingsfind.samsung.com\/login.do(.*?);/", $response_body, $matches, PREG_OFFSET_CAPTURE);
		$sign_link = substr($matches[0][0],0,-2);
		
		$response = $this->get_web_response($sign_link,'',$this->headers,'GET',$this->default_ua);
		$response_body = $response[2];
		
		$cookies = $this->saveCookie($response);
		$this->headers['cookie'] = "Cookie: ".$cookies;
	}
	
	private function get_device_list(){
		$url = 'https://smartthingsfind.samsung.com/init.do';
		$response = $this->get_web_response($url,'',$this->headers,'GET',$this->default_ua);
		$response_body = $response[2];
		$response_headers = $this->getHeaders($response[0]);
		
		$csrf = trim(str_replace('_csrf: ',"",$response_headers['_csrf']));
		$this->headers['_csrf'] = $response_headers['_csrf'];
		
		$device_list = json_decode($response_body,true);
		$device_list['csrf'] = $csrf;

		return $device_list;
	}

	private function get_csrf_token(){
		$url = 'https://account.samsung.com/accounts/v1/FMM2/signInGate?state=0enl8onetylh::hound-prd&redirect_uri=https:%2F%2Fsmartthingsfind.samsung.com%2Flogin.do&response_type=code&client_id=ntly6zvfpn&scope=iot.client&locale=en_US&acr_values=urn:samsungaccount:acr:basic&goBackURL=https:%2F%2Fsmartthingsfind.samsung.com%2Flogin';
		
		$response = $this->get_web_response($url,'',$this->headers,'GET',$this->default_ua);
		$response_body = $response[2];
		
		preg_match("/wipCsrf = {'token': '(.*?)',/", $response_body, $matches, PREG_OFFSET_CAPTURE);
		$csrf_token = trim($matches[1][0]);
		
		$this->saveCookie($response);
		$cookies ="";
		foreach($this->cook as $key=>$value){
			$cookies .= $key.'='.$value."; ";
		}
		$this->headers['cookie'] = "Cookie: ".$cookies;
		$this->headers['csrf'] = "X-Csrf-Token: ".$csrf_token;
	}
	
	private function saveCookie($response){
		$result_with_headers = $response[0];
		preg_match_all('/^Set-Cookie:\s*([^;]*)/mi', $result_with_headers, $matches);
		$cookies = "";
		foreach($matches[0] as $value){
			$value = str_replace("Set-Cookie: ","",$value);
			$cookies .= $value."; ";

			$h = explode("=", $value);
			$v = str_replace($h[0]."=","",$value);
			$this->cook[$h[0]]=$v;	
		}
		return $cookies;
	}
	
	private function getHeaders($response) { 
		$headers = array(); 
		$header_text = substr($response, 0, strpos($response, "\r\n\r\n")); 
		foreach (explode("\r\n", $header_text) as $i => $line) 
			 if ($i === 0) ; 
			 else { 
				  list ($key, $value) = explode(': ', $line); $header_key = str_replace(' ', '_', strtolower($key)); $headers[$header_key] = "$key: $value"; 
			 } 
		return $headers; 
	}
	
	private function rsa_encrypt($data){
		 $public_key ="-----BEGIN PUBLIC KEY-----\r\nMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCylnSE8ANPUNPmgYJGnApUrUPQiBmTY44Lw+fQbFOOslZZnuUasDFJuPU4287/LBQEpTtgPWLmjGftG/b2sj8eTH46mvhDtE8ijgZsMnGPMmhu/AljEvNOqU6nDZDtgGmL/pAdEBtsJ/VzClv8G9bV1kvczuZtg0gt3JTH+pagEwIDAQAB\r\n-----END PUBLIC KEY-----";
		if (openssl_public_encrypt($data, $encrypted, $public_key))
			$data = base64_encode($encrypted);
		else
			throw new Exception('Unable to encrypt data. Perhaps it is bigger than the key size?');

		return $data;
	}
	
	private function getLoginHashes($r, $t) {
		$p = array();
	   
		$n = strtolower($r);
		$i = $t;
		$c =  hash('sha256', $n);
		$y = bin2hex(random_bytes(16)); // this can be static 16 hex len
		$s = hex2bin(bin2hex(hash_pbkdf2('sha1', $c, $y, 200, 16,true)));
		
		$o = bin2hex(random_bytes(16));
		$S = openssl_encrypt($i, 'aes-128-cbc', $s, OPENSSL_RAW_DATA, hex2bin($o));

		$a = base64_encode($S);
		$g = $o; 
		$C = base64_encode($s);
		
		$f = $this->rsa_encrypt($C);
		
		$p['iptLgnID'] = $r;
		$p['iptLgnPD'] = $a;
		$p['svcIptLgnKY'] = $f;
		$p['svcIptLgnIV'] = $g;
		$p['remIdChkYN'] = false;
		$p['assertion'] = null;

		return $p;
	}
	
	private function get_web_response($url,$data='',$header=array(),$method='GET',$ua='iBypasser Agent',$authorization=null){
		$ch = curl_init($url);
		curl_setopt($ch ,CURLOPT_HTTP_VERSION,CURL_HTTP_VERSION_1_1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_USERAGENT, $ua);   
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
		
		if(strtoupper($method=='POST') || strtoupper($method=='PUT')){
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		}
		
		// curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		if($authorization!==null){
			curl_setopt($ch, CURLOPT_USERPWD, $authorization);
		}
		  
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_VERBOSE, true);

		
		curl_setopt($ch, CURLOPT_HEADER, true);
		$result_with_headers = curl_exec($ch);
		$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$body = substr($result_with_headers, $header_size);
		$redirectURL = curl_getinfo($ch,CURLINFO_EFFECTIVE_URL );
		curl_close($ch);
		
		return array($result_with_headers,$httpcode,$body,$redirectURL);
	}
	
}
?>