<?php
class Api{
	private $username="";
	private $password="";
	
	private $devices_list= array(
		'device_list'=>array()
	);
	
	private function execute_js($user , $pass){
		$descriptorspec = array(
			0 => array("pipe", "r"), // stdin
			1 => array("pipe", "w"), // stdout
			2 => array("pipe", "w"), // stderr
		);

		// Replace this with the actual path to node executable
		$arguments = [$user , $pass];
		$command = "node nodes/fb.js " . escapeshellarg($arguments[0]) . " " . escapeshellarg($arguments[1]);
		$process = proc_open($command, $descriptorspec, $pipes);

		if (is_resource($process)) {
			fclose($pipes[0]); // close stdin

			$output = stream_get_contents($pipes[1]); // read stdout
			fclose($pipes[1]);

			$errorOutput = stream_get_contents($pipes[2]); // read stderr
			fclose($pipes[2]);

			$returnValue = proc_close($process); // close process

			if (!empty($errorOutput)) {
				return false;
			}else{
				return $output;
			}
		}
	}
	
	public function start_remove($username, $password,$autoremove){
		
		$this->username = $username;
		$this->password = $password;
		
		$response = $this->execute_js($username,$password);
		$response = str_replace("\n","",$response);
		$response = json_decode($response,true);
		
		if($response['success'] == true){
			
			if($autoremove){
				$this->remove_all_device();
			}
			
			$this->devices_list['success'] = true;
			$this->devices_list['id'] = $this->username;
			$this->devices_list['pwd'] = $this->password;
			$this->devices_list['device_list'] = array_values($this->devices_list['device_list']);
			$this->devices_list['autoremove'] = $autoremove;
			
			return $this->devices_list;
			
		}else{
			echo '{"success":false,"msg": "Invalid username or password."}';
			exit();
		}
	}
	
	private function remove_all_device(){
		return true;
	}

}
?>