<?php

	$domain = $_GET['domain'] ?? '';
	$domain = urldecode($domain);

	$out['success'] = false;
	$out['msg'] = 'Error please contact system administrator';

	if (empty($domain) || ctype_space($domain)) {
		$out['msg'] = 'Domain is required!';
		echo json_encode($out);
		exit();
	}


	$url= 'https://safebrowsing.google.com/safebrowsing/report_error/?hl=en';
	$response = get_url_response($url);
	$dataSiteKey = trim(getDataSitekey($response[2]));

	$captcha = solve($dataSiteKey);
	$url = 'https://safebrowsing.google.com/safebrowsing/report_error/Captcha';
	$params = [
		'id' => '',
		'tpl' => '',
		'hl' => 'en',
		'hcr' => 'false',
		'_utf8' => '☃',
		'url' => $domain,
		'g-recaptcha-response' => $captcha,
		'dq' => get_random_reason()
	];
	
	$data = http_build_query($params);
	
	$response = get_url_response($url,$params,array(),'POST');
	$response_body = $response[2];

	if (strpos($response_body, 'submit_success') !== false) {
		 $out['success'] = true;
		 $out['msg'] = 'Please allow up to 24 hours for the removal of any red pages. We kindly ask that you refrain from submitting multiple requests during this time. Thank you for your patience and understanding.';
	}
	
	echo json_encode($out);
	
	
	
	function get_random_reason() {
		$reasons = [
			"Our domain has been incorrectly flagged for phishing. After a thorough review, we confirm that our site is secure and legitimate. We kindly request a reassessment to resolve this issue.",
			"We believe our domain was mistakenly flagged for phishing. Our site complies with all security standards and does not contain any harmful content. Please review and correct this flag.",
			"Our website has been inaccurately labeled as a phishing site. There is no malicious activity, and we have taken all necessary precautions to ensure user safety. Kindly reassess and remove the flag.",
			"This phishing warning appears to be an error. We have conducted a comprehensive security review and confirmed our website is safe and compliant. We request a re-evaluation to lift the flag.",
			"There are no security threats on our website, yet it has been flagged for phishing. We have verified its integrity and kindly ask for a review to rectify this mistake.",
			"It seems our domain was flagged in error. We use up‑to‑date SSL/TLS encryption and follow best practices—please review and remove the phishing designation.",
			"Our security audit found no signs of phishing or malware. This flag appears to be a false positive; we would appreciate a prompt reassessment.",
			"We maintain strict content controls and regular vulnerability scans. Despite this, our domain was flagged. Could you please reevaluate and clear the warning?",
			"Our site operates on a secured platform with firewalls and intrusion detection. The phishing alert seems misplaced—please help us correct this.",
			"We’ve implemented industry‑standard safeguards and zero malicious indicators were detected. We kindly ask that you remove the phishing flag.",
			"Our team performs routine security checks and code reviews. The phishing label conflicts with these results; please reconsider and lift the warning.",
			"We use Content Security Policy headers and secure cookie flags to protect users. Given our security measures, we believe the phishing flag is mistaken—please reassess.",
			"No unauthorized redirects or scripts were found on our domain. This phishing alert appears to be unwarranted; kindly remove it.",
			"Our website meets all compliance requirements, including HTTPS everywhere. We respectfully request a second look to remove the phishing designation.",
			"We take user safety very seriously and have scanned for threats—none were found. Could you please clear this false phishing warning?",
			"After a full internal audit, we found zero malicious elements. The phishing flag is likely a misclassification; please review and remove it.",
			"Our infrastructure is secured with regular patching and monitoring. This phishing alert seems to be a mistake—kindly re‑evaluate our site.",
			"We have no history of security incidents and follow OWASP guidelines. The phishing designation does not reflect our clean record—please lift it.",
			"All user data is encrypted and our site is free of phishing content. We would be grateful if you could remove this erroneous flag.",
			"We value your vigilance in security. Our domain passed every scan with no issues—please clear the phishing warning so legitimate users aren’t blocked."
		];
		return $reasons[array_rand($reasons)];
	}


	function getDataSitekey($html) {
		// Regular expression to match the data-sitekey attribute
		preg_match('/data-sitekey=["\']([^"\']+)["\']/i', $html, $matches);
		
		// Return the first match or null if not found
		return isset($matches[1]) ? $matches[1] : null;
	}

	
	function solve($siteKey){
		$apiKey = '66bd55cbb3e19d03beff15ba0e274f76';
		$requestUrl = 'http://2captcha.com/in.php';
		$data = [
			'key' => $apiKey,
			'method' => 'userrecaptcha',
			'googlekey' => $siteKey,
			'pageurl' => 'https://safebrowsing.google.com/safebrowsing/report_error/?hl=en',
			'json' => 1
		];
		
		$response = get_url_response($requestUrl,$data,array(),'POST');
		$response = json_decode($response[2],true);
		$captchaId = $response['request'];
		
		$resultUrl = "http://2captcha.com/res.php?key=$apiKey&action=get&id=$captchaId&json=1";
		$captchaSolution = '';
		while (true) {
			sleep(5);
			$response = get_url_response($resultUrl);
			$response = json_decode($response[2], true);

			if ($response['status'] === 1) {
				$captchaSolution = $response['request'];
				break;
			} elseif ($response['request'] !== 'CAPCHA_NOT_READY') {
				die('Error: ' . $response['request']);
			}
		}
		
		return $captchaSolution;
	}
	
	function get_url_response($url,$data='',$header=array(),$method='GET',$ua='iBypasser Agent',$authorization=null){
		$ch = curl_init($url);
		curl_setopt($ch ,CURLOPT_POST,true);
		curl_setopt($ch ,CURLOPT_HTTP_VERSION,CURL_HTTP_VERSION_1_1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_USERAGENT, $ua);   
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
		
		if(strtoupper($method=='POST') || strtoupper($method=='PUT') || strtoupper($method=='PATCH')){
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		}
		
		// curl_setopt($ch, CURLOPT_ENCODING, 'UTF-8');
		if($authorization!==null){
			curl_setopt($ch, CURLOPT_USERPWD, $authorization);
		}
		  
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
		curl_setopt($ch, CURLOPT_VERBOSE, true);

		
		curl_setopt($ch, CURLOPT_HEADER, true);
		$result_with_headers = curl_exec($ch);
		$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$body = substr($result_with_headers, $header_size);
		
		curl_close($ch);
		
		return array($result_with_headers,$httpcode,$body);
	}
	
	
	function debug($arr){
		echo '<pre>';
		print_r($arr);
		echo '</pre>';
		exit();
	}

?>