process.on('uncaughtException', function(er) {
	console.log(er);
});
process.on('unhandledRejection', function(er) {
	console.log(er);
});

const {
    firefox
} = require('playwright-extra');

const apple_id = process.argv[2];
const password = process.argv[3];

async function start() {
	 firefox.launch({
        headless: true,
        timeout: 10000,
        ignoreHTTPSErrors: true,
        args: [
            '--no-sandbox',
            '--disable-setuid-sandbox',
            '--disable-dev-shm-usage',
            '--disable-accelerated-2d-canvas',
            '--no-first-run',
            '--no-zygote',
            '--single-process', // <- this one doesn't work on Windows
            '--disable-gpu'
        ]
    }).then(async browser => {
		const context = await browser.newContext({ timeout: 10000 })
		const page = await context.newPage()
        await page.setViewportSize({
            width: 500,
            height: 500
        });
		await page.setDefaultNavigationTimeout(30000);

		 try {
			 
			await page.route("https://setup.icloud.com/setup/ws/1/accountLogin**", route => {
			  route.continue();
			});
			
            await page.goto('https://www.icloud.com/find');
			
			var signinbtn = page.locator(".sign-in-button");
			await signinbtn.waitFor({state: "visible"});
			
			await signinbtn.click();
			
			const login_frame = await page.frameLocator('#aid-auth-widget-iFrame');
			
			const input_email = login_frame.locator("#account_name_text_field");
			await input_email.waitFor({state: "visible"});
			input_email.fill(apple_id);
			
			//sign-in
			signinbtn = login_frame.locator("#sign-in");
			await signinbtn.waitFor({state: "visible"});
			await signinbtn.click();
			
			//password_text_field
			const input_pass = login_frame.locator("#password_text_field");
			await input_pass.waitFor({state: "visible"});
			input_pass.fill(password);
			await signinbtn.click();
			
			page.on('request', async (request) => {
			  const requestUrl = request.url();
			  if (requestUrl.includes('setup/ws/1/accountLogin')) {
				console.log(request.postData());
				await browser.close();
			  }
			});
	
        } catch (error1) {
            await browser.close();
			console.log(error1);
			console.log('[]');
        }

	});
}

start();